<?php
/**
 * Top Ranking
 * https://webenginecms.org/
 * 
 * @version 1.1.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2019 Lautaro Angelico, All Rights Reserved
 * @build w3c8c718b75a0f1fa1a557f7f9d70877
 */

// namespace
namespace Plugin\TopRanking;

// plugin root
define('__PATH_TOPRANKING_ROOT__', __PATH_PLUGINS__.'topranking/');

// plugin home
define('__TOPRANKING_HOME__', __BASE_URL__.'rankings/top/');

// admincp
$extra_admincp_sidebar[] = array(
    'Top Ranking', array(
        array('Settings','topranking&page=settings')
    )
);

// language
if(file_exists(__PATH_TOPRANKING_ROOT__ . 'languages/'.config('language_default', true).'/language.php')) {
	if(!@include_once(__PATH_TOPRANKING_ROOT__ . 'languages/'.config('language_default', true).'/language.php')) {
		throw new Exception('Error loading language file (topranking)');
	}
} else {
	// load default language file (en)
	if(!@include_once(__PATH_TOPRANKING_ROOT__ . 'languages/en/language.php')) {
		throw new Exception('Error loading language file (topranking)');
	}
}

// load classes
if(!@include_once(__PATH_TOPRANKING_ROOT__ . 'classes/class.topranking.php')) {
	throw new Exception(lang('topranking_error_1', true));
}

// rankings menu
addRankingMenuLink(lang('topranking_title'), 'top', array('igcn'));